# AdoScript Literals and Expressions

Literals and expressions are used to in code to denote values. Literals
represent specific values in the code to use. Expressions represent code that
has to be evaluated to determine a value.

> The individual examples can be tested using a `CC "AdoScript" INFOBOX (...)`
> or a `CC "AdoScript" VIEWBOX text:(STR ...)` command.

In the end both literals and expressions represent a value. This value is of a
specific type. The following list describes the types that are used in
AdoScript and also how they are referred to in this documentation:
* `intValue` - A positive or negative integer number, i.e. a number without a
  fractional part. Integer values are written directly as their number.
  Examples are: 0, 1, 2, 5, 5438, 79957234, -1, -3, -5422 etc.
* `realValue` - A positive or negative real number, i.e. a number that has both
  a decimal part and a fractional part. Real values are written directly as
  their number. Examples are: 0.0, 1.4, 5.42, -2.6 etc.
* `strValue` - A sequence of characters (bytes) typically called a string. It
  is mostly used to store text. Strings are written between double quotes `"`
  and use the backslash `\` to escape various characters. Examples are:
  "Hello I am a string", "Size: 42", "Line 1\nLine 2" etc.
* `timeValue` - A time denotes a specific point in a time period or more
  commonly a duration. It uses the format YY:DDD:HH:MM:SS, with years, days,
  hours, minutes and seconds. Examples are: 00:000:00:05:00, 00:000:01:00:00,
  00:001:00:00:00, 23:094:11:15:42 etc.
* `measureValue` - A measure indicates a spacial distance as a single real
  number. It is generally from a point of reference, is one-dimensional and can
  be positive or negative indicating direction. The spatial details are handled
  by the context it is used in, e.g. when used for a parameter x it typically
  means a distance on the x-Axis. It differs from `realValue` by also
  specifying a unit. The allowed units are mm, cm, m and pt, with cm being the
  most commonly used one. Examples are: 1cm, 1.5cm, 15mm, 18pt etc.
* `arrayValue` - An array is a sequence of other values. The values can be of
  different types, even in the same array. An array can be multi-dimensional
  and also contain other arrays. The order of the values in an array is
  relevant. The values in an array are accessed by their index, starting at 0
  as the first index. The size of an array is not fixed and can be increased or
  decreased as needed. Arrays start with opening curly-brackets `{`, end with
  closing curly-brackets `}` and the values inside an array are separated by
  commas `,`. Examples are: {1, 2, 3}, {2, 1, 3}, {"a", 1, "b", 2},
  {1, 1cm, {"a", "b"}, "c"} etc.
* `mapValue` - A map is a collection of key-value pairs. The keys and values
  can be of different types, even in the same map. The key specifies the
  "identifier" under which a value is located / can be accessed. It is
  recommended to use simple values (`intValue`, `realValue`, `strValue`,
  `timeValue`, `measureValue` or similar) for keys. Values can be any type,
  including arrays or other maps. This allows to build tree structures through
  maps. The key-value pairs are sorted internally by the map and it should be
  avoided to rely on a specific sorting. The size of a map is not fixed and can
  be increased or decreased as needed. Arrays start with opening curly-brackets
  `{`, end with closing curly-brackets `}` and the key-value pairs inside are
  separated by commas `,` while the key and the value are separated by a colon
  `:`. Examples are {"a": 1, "b": 2}, {1cm: "a", "b": 00:000:01:00:00},
  {"an array": {1, 2, 3}, "a number": 42, "a map": {"a": "A", "b": "B"}} etc.

> A note on `strValue`: These are MOSTLY used to store and process text. The
> end of the text is denoted by a null character (0x00). Almost all functions
> operating on a string treat the content as text. There are however a few
> cases where strings are used to store a sequence of binary data, which can
> include the null character (see the command `"AdoScript" FREAD` and
> `"AdoScript" FWRITE`, both used with the `binary` parameter). The
> documentation does however indicate where this is the case. Still, be mindful
> not to mix a string that stores binary data with functions that work on text.

Furthermore this documentation uses some special types to also indicate the
purpose of variables or returned values. These are realized using the
previously described types and are for the program indistinguishable from them.
However, for the purpose of the documentation they provide a useful meaning for
the programmer.
* `anyValue` - This indicates that "any" type of value can be used. Which types
  of values are actually valid depends on the command. Typically these are
  `intValue`, `realValue`, `strValue`, `timeValue` or `measureValue`.
* `boolValue` - This indicates that the provided value denotes "truthfulness".
  What values are considered "true" or "false" depends on their type: numeric
  values (`intValue`, `realValue`, `timeValue`, `measureValue`) are considered
  "true" if they are not 0 and `strValue` are considered "true" when their
  length is not 0. All other values are considered "false". The most common
  used `boolValue` are 0 and 1.
* `idValue` - This indicates that an identifier (ID) is used. An identifier is
  always a positive integer number (`intValue`). IDs are also larger than zero,
  with the exception of some very specific cases deep inside the core of the
  platform that is seldomly used directly.
* `tokenStr` - This indicates that a list of tokens is used. These are always
  strings (`strValue`) and are sometimes called a "string list". The tokens of
  a string list are separated using a specific character, typically a white
  space ` `. String lists are intended to be used with various functions and
  commands for processing them, like the token version of the `FOR` loop or
  functions like `token(...)`, `tokcnt(...)`, `tokcat(...)`, `tokunion(...)`
  etc. They are a `strValue` based alternative to arrays.
* `enumValue` - This indicates that only specific pre-defined values are
  allowed.

Some other less common types:
* `null` (is this even somehow available or is it just internally?)
* `undefined` - refers to a variable that has not been initialized.
* `expr` (expression)
* `ref` (reference?)
* `lambda` ("a function" as a value)
* `object` (???)



## String functions

* [encodeuri( content, allowed )](Functions/encodeuri.md)



## Map functions

* [tourlquerystring ( amap, allowed )](Functions/tourlquerystring.md)
